/*=============================================================================

This do file brings in U.S. state level data on
I. 	Employment by Industry, 1970-2011
II. Nominal GDP, 1970-2011

Source of data used in this dofile: 
BEA Regional Economic Accounts
Downloaded from: http://www.bea.gov/regional/downloadzip.cfm
	
Yearbooks use NACE 70. See 1972: Regional statistics (1975), p. 48, for industry breakdowns used in yearbooks
For NACE 70 correspondance with modern NACE, see http://datalib.chass.utoronto.ca/other/E0032_en.pdf, pp. 177-183

==============================================================================*/

clear all
set more off

*Employment by Industry, 1970
clear
set more off

#delim ;
local states 
"AL
AK
AZ
AR
CA
CO
CT
DC
DE
FL
GA
HI
ID
IL
IN
IA
KS
KY
LA
ME
MD
MA
MI
MN
MS
MO
MT
NE
NV
NH
NJ
NM
NY
NC
ND
OH
OK
OR
PA
RI
SC
SD
TN
TX
UT
VT
VA
WA
WV
WI
WY" ; 
#delim cr

*Employment, by Industry
cd "$data/USA/bea_regional/spi"

*SIC Codes, 1970-2001 
foreach state of local states { 
	clear
	quietly insheet using SA25_1969_2001_`state'.csv
	
	quietly keep statefips linecode v9-v40 
	quietly destring statefips, replace force 
		quietly drop if statefips==. //drops footnotes
	quietly destring linecode, replace force
	quietly destring v*, replace force
	
	local year2=1970
	foreach var of varlist v9 - v40 {
		rename `var' ind_`year2'
		local year2= `year2'+1 
	}
	
	quietly reshape wide ind_*, i(statefip) j(linecode)
	
	display "`state'"
	
	forval year = 1970/2001 {
		tempfile sicind_`year'
		quietly save `sicind_`year'.dta' 
		
		display "`year'"
		quietly keep statefip ind_`year'*
		
		egen ind_agro`year' = rsum(ind_`year'70 ind_`year'100) 

		egen ind_energy`year' = rsum(ind_`year'220 ind_`year'230 ind_`year'474 ind_`year'570)
		egen ind_mining`year' = rsum(ind_`year'210 ind_`year'240 ind_`year'471)
		gen ind_construction`year' = ind_`year'300
		egen ind_metals`year' = rsum(ind_`year'423-ind_`year'441 ind_`year'447)
		egen ind_other`year' = rsum(ind_`year'413-ind_`year'420 ind_`year'444 ind_`year'453-ind_`year'468 ind_`year'477-ind_`year'480)
		egen ind_total`year' = rsum(ind_energy`year'-ind_other`year') 
		
		gen ind_mnfg`year' = ind_metals`year'+ind_other`year'

		egen serv_commerce`year' = rsum(ind_`year'610 ind_`year'620 ind_`year'805 ind_`year'825 ind_`year'830)
		egen serv_transport`year' = rsum(ind_`year'510 ind_`year'520 ind_`year'530 ind_`year'540 ind_`year'560)
		egen serv_credit`year' = rsum(ind_`year'700 ind_`year'820)
		gen serv_admin`year' = ind_`year'900
		egen serv_other`year' = rsum(ind_`year'810 ind_`year'815 ind_`year'835-ind_`year'880)
		egen serv_total`year' = rsum(serv_commerce`year'-serv_other`year')

		gen year = `year'

		quietly keep statefip year ind_agro`year'-serv_total`year'
		quietly rename statefips statefip
		rename ind_agro`year' ind_agro
		rename ind_energy`year' ind_energy
		rename ind_mining`year' ind_mining
		rename ind_construction`year' ind_construction
		rename ind_metals`year' ind_metals
		rename ind_other`year' ind_other
		rename ind_total`year' ind_total
		rename ind_mnfg`year' ind_mnfg
		rename serv_commerce`year' serv_commerce
		rename serv_transport`year' serv_transport
		rename serv_credit`year' serv_credit
		rename serv_admin`year' serv_admin
		rename serv_other`year' serv_other
		rename serv_total`year' serv_total
		
		tempfile Ind_EMP_`state'_`year'
		quietly save `Ind_EMP_`state'_`year'.dta'
		use `sicind_`year'.dta', clear
	}
}	

clear
forval year = 1970/2001 {
	foreach state of local states { 
		capture quietly append using `Ind_EMP_`state'_`year'.dta'
	}
}

duplicates drop

gen sic = 1

sort statefip
save "$dta_files/BEA_SIC_1970_2001.dta", replace

clear

*NAICS Codes, 1990-2011 

foreach state of local states { 
	clear
	quietly insheet using SA25N_1990_2011_`state'.csv
	
	quietly keep statefips linecode v8-v29 
	quietly destring statefips, replace force 
		quietly drop if statefips==. //drops footnotes
	quietly destring linecode, replace force
	quietly destring v*, replace force
	
	local year2=1990
	foreach var of varlist v8 - v29 {
		rename `var' ind_`year2'
		local year2= `year2'+1 
	}
	
	quietly reshape wide ind_*, i(statefip) j(linecode)
	
	display "`state'"
	
	forval year = 1990/2011 {
		tempfile sicind_`year'
		quietly save `sicind_`year'.dta' 
		display "`year'"

		quietly keep statefip ind_`year'*
		
		*****************************************************************				
		*MAKE ADJUSTMENTS TO MAKE NAICS COMPARABLE WITH EARLIER SIC DATA
			replace ind_`year'1200 = ind_`year'1200 - ( ind_`year'539*1/0.254911998 - ind_`year'539) if "`state'" =="DE"
			replace ind_`year'541 = ind_`year'541*1/0.254911998 if "`state'" =="DE" //inflate by average relationship between chemicals (SIC) relative to NAICS employees during the 1990-2000 decade of overlap between SIC and NAICS codes
		
			replace ind_`year'1200 = ind_`year'1200 - ( ind_`year'539*1/0.971630443 - ind_`year'539) if "`state'" !="DE"
			replace ind_`year'541 = ind_`year'541*1/0.971630443  if "`state'" !="DE" //inflate by average relationship between chemicals (SIC) relative to NAICS employees during the 1990-2000 decade of overlap between SIC and NAICS codes

		*****************************************************************
		
		egen ind_agro`year' = rsum(ind_`year'70 ind_`year'100) 

		egen ind_energy`year' = rsum(ind_`year'201 ind_`year'300 ind_`year'539 ind_`year'806 ind_`year'1402)
		egen ind_mining`year' = rsum(ind_`year'202 ind_`year'203 ind_`year'541)
		gen ind_construction`year' = ind_`year'400
		egen ind_metals`year' = rsum(ind_`year'513-ind_`year'519)
		egen ind_other`year' = rsum(  ind_`year'511-ind_`year'512 ind_`year'521-ind_`year'522 ind_`year'531-ind_`year'538 ind_`year'542 )
		egen ind_total`year' = rsum(ind_energy`year'-ind_other`year') 
		
		gen ind_mnfg`year' = ind_metals`year'+ind_other`year'

		egen serv_commerce`year' = rsum(ind_`year'600 ind_`year'700 ind_`year'1801 ind_`year'1901 ind_`year'1802)
		egen serv_transport`year' = rsum(ind_`year'801-ind_`year'805 ind_`year'807-ind_`year'811)
		egen serv_credit`year' = rsum(ind_`year'1000 ind_`year'1100  ind_`year'1300 ind_`year'1401)
		gen serv_admin`year' = ind_`year'2000 
		egen serv_other`year' = rsum(ind_`year'900 ind_`year'1200 ind_`year'1500 ind_`year'1600 ind_`year'1700 ind_`year'1900  )
		egen serv_total`year' = rsum(serv_commerce`year'-serv_other`year')

		gen year = `year'

		quietly keep statefip year ind_agro`year'-serv_total`year'
		rename statefips statefip
		rename ind_agro`year' ind_agro
		rename ind_energy`year' ind_energy
		rename ind_mining`year' ind_mining
		rename ind_construction`year' ind_construction
		rename ind_metals`year' ind_metals
		rename ind_other`year' ind_other
		rename ind_total`year' ind_total
		rename ind_mnfg`year' ind_mnfg
		rename serv_commerce`year' serv_commerce
		rename serv_transport`year' serv_transport
		rename serv_credit`year' serv_credit
		rename serv_admin`year' serv_admin
		rename serv_other`year' serv_other
		rename serv_total`year' serv_total		
		
		tempfile Ind_EMP_`state'_`year'
		quietly save `Ind_EMP_`state'_`year'.dta'
		use `sicind_`year'.dta', clear
	}
}	

clear
forval year = 1990/2011 {
	foreach state of local states { 
		capture quietly append using `Ind_EMP_`state'_`year'.dta'
	}
}

gen naics = 1

sort statefip
save "$dta_files/BEA_NAICS_1990_2011.dta", replace

* ==============================================================================
*II. Nominal GDP, 1970-2011
* ==============================================================================

clear
cd "$data/USA/bea_regional"

insheet using gsp_sic_all_C.csv
keep if industryid==1 //all industries
keep if fips>0 & fips<=56

forvalues x=8/42 {
	local year = 1955+`x'
	quietly rename v`x' v`year'
}


keep fips v1963-v1996
reshape long v, i(fips)

tempfile sic
save `sic'

clear
insheet using gsp_naics_all_C.csv

keep if industryid==101 //all industries
keep if fips>0 & fips<=56

forvalues x=8/22 {
	local year = 1989+`x'
	rename v`x' v`year'
}

keep fips v1997-v2011
reshape long v, i(fips)

append using `sic' 

rename _j year 
rename v gdp
	quietly destring gdp, replace 
rename fips statefip
save "$dta_files/TS_GDP_US", replace

use "$dta_files/BEA_SIC_1970_2001.dta", clear
keep if year<1990
merge 1:1 statefip year using "$dta_files/BEA_NAICS_1990_2011.dta", nogen 
merge 1:1 statefip year using "$dta_files/TS_GDP_US",  nogen

keep if year>=1970 
drop sic naics

rename ind_agro ts_ind_agro
rename ind_energy ts_ind_energy
rename ind_mining ts_ind_mining
rename ind_construction ts_ind_construction
rename ind_metals ts_ind_metals
rename ind_other ts_ind_other
rename ind_total ts_ind_total
rename ind_mnfg ts_ind_mnfg
rename serv_commerce ts_serv_commerce
rename serv_transport ts_serv_transport
rename serv_credit ts_serv_credit
rename serv_admin ts_serv_admin
rename serv_other ts_serv_other
rename serv_total ts_serv_total

rename gdp ts_gdp

save "$dta_files/TS_US_BEA.dta", replace
